{
prog: Get pictures for SCC Blaffer, convert them to MSX format, and make one
      file of it.
code: d-fader^TwZ
date: june 5, 1999
cmnt: none.
}

uses crt;

const
  header: array[0..6] of byte = ($fe, $00, $00, $0f, $77, $00, $00);

var
  f1       : file;
  f2       : text;
  data     : string[80];
  one_file : array[0..24*80-1] of byte;
  i        : byte;
  j        : byte;
  k        : byte;


BEGIN
  if paramcount < 2 then
    begin
      writeln ('Usage: MAKE_MSX <destination filename> <source 1> [source 2] .. [source 8]');
      halt (255);
	 end;


  assign (f1, paramstr (1));

  {$I-}
  rewrite (f1, 1);
  {$I+}

  BlockWrite (f1, header, 7);

  if IOResult <> 0 then
    begin
      writeln ('Error Creating: ', paramstr (1), '...');
      halt (254);
    end;


  for i := 2 to paramcount do
    begin
      assign (f2, paramstr(i));

      {$I-}
      reset (f2);
      {$I+}

      if IOResult <> 0 then
        begin
          writeln ('Error Opening: ', paramstr (i), '...');

          close (f1);

          erase (f1);

          halt (254);
        end;


      for j := 0 to 23 do
        begin
          readln (f2, data);

          for k := 1 to 80 do
            begin
              if ord (data[k]) = 193 then data[k] := chr(17); {  }
              if ord (data[k]) = 194 then data[k] := chr(18); {  }
              if ord (data[k]) = 180 then data[k] := chr(19); {  }
              if ord (data[k]) = 195 then data[k] := chr(20); {  }
              if ord (data[k]) = 197 then data[k] := chr(21); {  }
              if ord (data[k]) = 179 then data[k] := chr(22); {  }
              if ord (data[k]) = 196 then data[k] := chr(23); {  }
              if ord (data[k]) = 218 then data[k] := chr(24); {  }
              if ord (data[k]) = 191 then data[k] := chr(25); {  }
              if ord (data[k]) = 192 then data[k] := chr(26); {  }
              if ord (data[k]) = 217 then data[k] := chr(27); {  }
          end;


          write (data);

          move (data[1], one_file[j*80], 80);
        end;

      close (f2);

      BlockWrite (f1, one_file, SizeOf (one_file));
    end;

  close (f1);

  clrscr;

  for i := 2 to ParamCount do
    writeln ('File: ', ParamStr(i), ' is picture ', i - 2, '...');

END.

